<?php
defined('MOODLE_INTERNAL') || die();

use core_completion\progress;

global $CFG;
require_once $CFG->libdir . '/externallib.php';
require_once $CFG->dirroot . '/course/classes/category.php';
require_once $CFG->dirroot . '/blocks/moodleblock.class.php';
require_once $CFG->dirroot . '/blocks/course_list/block_course_list.php';

class block_cursos_catalogo_ajax_external extends \external_api
{

    public static function enrolar_usuario_cursos_catalogo_parameters()
    {
        return new \external_function_parameters([
            'courseid' => new \external_value(PARAM_INT, 'ID del curso', VALUE_DEFAULT, 0)
        ]);
    }

    public static function enrolar_usuario_cursos_catalogo($courseid)
    {
        global $USER, $DB, $CFG;

        $userid = $USER->id;
        $course = get_course($courseid);
        $enrol = false;

        if (! $course) {
            return json_encode([
                'success' => false,
                'data' => 'No existe el curso'
            ]);
        }

        $enrolmethod = 'self';

        $instance = $DB->get_record('enrol', [
            'courseid' => $course->id,
            'enrol' => $enrolmethod,
            'status' => 0
        ]);
        if (! $instance) {
            return json_encode([
                'success' => false,
                'data' => 'El curso no permite auto inscribirse'
            ]);
        }

        try {
            $user = $DB->get_record('user', [
                'id' => $userid
            ]);
            $role = $DB->get_record('role', array(
                'archetype' => 'student'
            ));
            $context = context_course::instance($course->id);

            $context = context_course::instance($course->id);
            if (is_enrolled($context, $user)) {
                return json_encode([
                    'success' => true
                ]);
            } else {
                $enrol = enrol_get_plugin($enrolmethod);
                if ($enrol === null) {
                    return false;
                }
                $instances = enrol_get_instances($course->id, true);
                $manualinstance = null;
                foreach ($instances as $instance) {
                    if ($instance->name == $enrolmethod) {
                        $manualinstance = $instance;
                        break;
                    }
                }
                if ($manualinstance !== null) {
                    $instanceid = $enrol->add_default_instance($course);
                    if ($instanceid === null) {
                        $instanceid = $enrol->add_instance($course);
                    }
                    $instance = $DB->get_record('enrol', array(
                        'id' => $instanceid
                    ));
                }
                $enrol->enrol_user($instance, $user->id, $role->id);
            }

            return json_encode([
                'success' => true
            ]);
        } catch (\Exception $e) {
            error_log($e->getTraceAsString());

            return json_encode([
                'success' => false,
                'data' => $e->getMessage()
            ]);
        }
    }

    public static function enrolar_usuario_cursos_catalogo_returns()
    {
        return new \external_value(PARAM_RAW, 'The updated JSON output');
    }

    public static function get_cursos_catalogo_parameters()
    {
        return new \external_function_parameters([
            'category_id' => new \external_value(PARAM_INT, 'Categoría de los Cursos', VALUE_DEFAULT, 0),
            'search_text' => new \external_value(PARAM_ALPHANUM, 'Palabra de busqueda', VALUE_DEFAULT, ' '),
            'page' => new \external_value(PARAM_INT, 'Número de página', VALUE_DEFAULT, 1),
            'perpage' => new \external_value(PARAM_INT, 'Cursos por página', VALUE_DEFAULT, 10)
        ]);
    }

    public static function get_cursos_catalogo($category_id, $search_text, $page = 1, $perpage = 10)
    {
        global $USER, $DB, $CFG, $OUTPUT, $PAGE;

        $params = self::validate_parameters(self::get_cursos_catalogo_parameters(), compact('category_id', 'search_text', 'page', 'perpage'));

        $page = max(1, $params['page']);
        $perpage = max(10, $params['perpage']);

        $userid = $USER->id;
        $url_noimage = $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';

        $is_admin = false;
        $admins = get_admins();
        foreach ($admins as $admin) {
            if ($USER->id == $admin->id) {
                $is_admin = true;
                break;
            }
        }

        $all_categories = [];
        $records = $DB->get_records('course_categories', [
            'visible' => 1
        ], 'sortorder, name');
        foreach ($records as $record) {
            $all_categories[$record->id] = $record;
        }

        $categories_ids = [];
        $category_filter_active = false;
        if ($category_id) {
            $category_filter_active = true;

            $recordLevel0 = $DB->get_record('course_categories', [
                'id' => $category_id
            ]);

            if ($recordLevel0) {
                array_push($categories_ids, $recordLevel0->id);

                $recordsLevel1 = $DB->get_records('course_categories', [
                    'visible' => 1,
                    'parent' => $recordLevel0->id
                ]);

                foreach ($recordsLevel1 as $recordLevel1) {

                    array_push($categories_ids, $recordLevel1->id);

                    $recordsLevel2 = $DB->get_records('course_categories', [
                        'visible' => 1,
                        'parent' => $recordLevel1->id
                    ]);
                    foreach ($recordsLevel2 as $recordLevel2) {
                        array_push($categories_ids, $recordLevel2->id);

                        $recordsLevel3 = $DB->get_records('course_categories', [
                            'visible' => 2,
                            'parent' => $recordLevel2->id
                        ]);
                        foreach ($recordsLevel3 as $recordLevel3) {
                            array_push($categories_ids, $recordLevel3->id);
                        }
                    }
                }
            }
        }

        $course_ids = [];
        $course_category_ids = [];
        $courseAvailableForAutoRol = [];

        if ($is_admin) {
            $mycourses = get_courses(); // get_courses_search($searchterms, $sort, $page, $perpage, $total_courses);
        } else {
            $mycourses = enrol_get_users_courses($USER->id);
            $courses_with_autoenrol = $DB->get_records('enrol', [
                'enrol' => 'self',
                'status' => 0
            ]);
            foreach ($courses_with_autoenrol as $course_with_autoenrol) {
                $course = get_course($course_with_autoenrol->courseid);
                array_push($mycourses, $course);

                array_push($courseAvailableForAutoRol, $course->id);
            }
        }

        $mycourses = array_filter($mycourses, function ($course) use ($search_text, $category_filter_active, $categories_ids) {
            if (! $course->visible) {
                return false;
            }

            if ($search_text) {
                if (stripos($course->fullname, $search_text) === false) {
                    return false;
                }
            }

            if ($category_filter_active) {
                if (! in_array($course->category, $categories_ids)) {
                    return false;
                }
            }

            return true;
        });

        usort($mycourses, function ($a, $b) {

            if ($a->timecreated == $b->timecreated) {
                return $a->fullname <=> $b->fullname;
            } else {
                return $a->timecreated > $b->timecreated ? -1 : 1;
            }
        });

        /*
         * $searchterms = array();
         * $sort = "c.sortorder DESC";
         */

        $total_courses = count($mycourses);
        $total_pages = ceil($total_courses / $perpage);
        if ($total_pages * $perpage < $total_courses) {
            $total_pages++;
        }

        $page = isset($page) ? max(1, min($page, $total_pages)) : 1;

        $max_links = 3;
        $start_page = max(1, $page - floor($max_links / 2));
        $end_page = min($total_pages, $start_page + $max_links - 1);

        if ($end_page - $start_page + 1 < $max_links) {
            $start_page = max(1, $end_page - $max_links + 1);
        }

        $start = $page == 1 ? 0 : ($page - 1) * $perpage;
        $mycourses = array_slice($mycourses, $start, $perpage);

        $courses = [];
        /*
         * foreach ($course_ids as $course_id) {
         * $course = get_course($course_id);
         */

        foreach ($mycourses as $course) {

            if ($course instanceof stdClass) {
                $coreCourseList = new core_course_list_element($course);
            }

            if (! in_array($course->category, $course_category_ids)) {
                array_push($course_category_ids, $course->category);
            }

            $image = $url_noimage;
            foreach ($coreCourseList->get_course_overviewfiles() as $file) {
                $isimage = $file->is_valid_image();
                $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), ! $isimage);
                if (! $isimage) {
                    $image = $url_noimage;
                }
            }

            $lastaccess = null;
            $sql = "select timecreated from {logstore_standard_log} where courseid = :courseid and userid = :userid order by id limit {$perpage}";
            $params_a = [
                'courseid' => $course->id,
                'userid' => $userid
            ];
            $timecreated = $DB->get_field_sql($sql, $params_a);
            if ($timecreated) {

                $lastaccess = date('d/m/Y h:i a', $timecreated);
            }

            $first_section = 0;
            $sections = $DB->get_records('course_sections', [
                'course' => $course->id
            ], 'section desc', 'id,name,section,sequence,visible');

            foreach ($sections as $section) {
                if (! empty($section->section)) {
                    $first_section = $section->id;
                    break;
                }
            }



            $course_context = context_course::instance($course->id);
            $roles = get_user_roles($course_context, $USER->id, true);


            if (has_capability('moodle/course:manageactivities', $course_context, $USER->id) || has_capability('moodle/course:viewhiddenactivities', $course_context, $USER->id)) {
                $editurl = $CFG->wwwroot . '/course/view.php?id=' . $course->id . '&notifyeditingon=1';

                //$editurl = $CFG->wwwroot . '/course/edit.php?id=' . $course->id;
            } else {
                $editurl = '';
            }

            $modules = get_fast_modinfo($course->id)->get_cms();



            $viewurl = '';
            foreach ($modules as $module) {
                if (!$module->uservisible || $module->is_stealth() || empty($module->url)) {
                    continue;
                }

                $viewurl = new moodle_url($module->url, array(
                    'forceview' => 1
                ));
                break;
            }

            $summary = trim(strip_tags($course->summary));

            if (empty($summary)) {
                $summary = ' ';
            } else if (strlen($summary) > 80) {

                $summary = substr($summary, 0, 80) . '...';
            }

            if (empty($editurl) && in_array($course->id, $courseAvailableForAutoRol)) {
                $autoenrol = 'yes';
            } else {
                $autoenrol = '';
            }

            $category = $all_categories[$course->category];
            if ($category->parent) {
                $categoryParent = $all_categories[$category->parent];
                if ($categoryParent) {
                    $categoryName = $categoryParent->name . ' / ' . $category->name;
                } else {
                    $categoryName = $category->name;
                }
            } else {
                $categoryName = $category->name;
            }
            if (strlen($categoryName) > 40) {

                $categoryName = substr($categoryName, 0, 40) . '...';
            }

            // echo '<pre>';
            // echo '$categoryName = ' . $categoryName . ' $course->category = ' . $course->category;
            // echo '</pre>';

            array_push($courses, [
                'courseid' => $course->id,
                'coursecategory' => $categoryName,
                'courseimage' => $image,
                'enddate' => $course->enddate,
                'fullname' => $course->fullname,
                'fullnamedisplay' => get_course_display_name_for_list($course),
                'hidden' => false,
                'id' => $course->id,
                'idnumber' => $course->idnumber,
                'isfavourite' => false,
                'shortname' => $course->shortname,
                'showshortname' => false,
                'startdate' => $course->startdate,
                'summary' => $summary,
                'summaryformat' => $course->summaryformat,
                'timeaccess' => $lastaccess,
                'viewurl' => $viewurl,
                'editurl' => $editurl,
                'autoenrol' => $autoenrol,
                'visible' => true
            ]);
        }

        $categories = [];

        foreach ($course_category_ids as $course_category_id) {
            $category = $all_categories[$course_category_id];
            if ($category) {
                array_push($categories, [
                    'id' => $category->id,
                    'name' => $category->name
                ]);
            }
        }

        // Crear el array de navegación con el rango dinámico
        $pagination = [
            'current_page' => $page,
            'total_pages' => $total_pages,
            'has_previous' => $page > 1,
            'has_next' => $page < $total_pages,
            'previous_page' => $page > 1 ? $page - 1 : null,
            'next_page' => $page < $total_pages ? $page + 1 : null,
            'pages' => array_map(function ($p) use ($page) {
                return [
                    'number' => $p,
                    'is_current' => $p === $page
                ];
            }, range($start_page, $end_page))
        ];

        // Preparar los datos para la plantilla
        $data = [
            'courses' => $courses,
            'pagination' => $pagination
        ];

        $cards = $OUTPUT->render_from_template('block_cursos_catalogo_ajax/cards', $data);

        $data = [
            'categories' => $categories
        ];

        $badges = $OUTPUT->render_from_template('block_cursos_catalogo_ajax/badges', $data);

        return json_encode([
            'success' => true,
            'search_text' => $search_text,
            'category_id' => $category_id,
            'cards' => $cards,
            'badges' => $badges,
            'courses' => $courses
        ]);
    }

    public static function get_cursos_catalogo_returns()
    {
        return new \external_value(PARAM_RAW, 'The updated JSON output');
    }
}
