<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The cesa_notes block
 *
 * @package    block_cesa_notes
 * @author     Gautam Kumar Das<gautam.arg@gmail.com>
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/blocks/cesa_notes/lib.php');

/**
 * cesa_notes block.
 *
 * @package    block_cesa_notes
 * 
 */
class block_cesa_notes extends block_base
{

    public function init()
    {
        $this->title = get_string('pluginname', 'block_cesa_notes');
    }

    public function has_config()
    {
        return true;
    }

    public function applicable_formats()
    {
        return array('all' => true);
    }

    public function instance_allow_multiple()
    {
        return false;
    }

    function specialization()
    {
        global $CFG, $DB;
        if (empty($this->config)) {
            $this->instance->defaultregion = 'side-pre';
            $this->instance->region = 'side-pre';
            $DB->update_record('block_instances', $this->instance);

            $this->title = 'Apuntes y resumen';
        } else {
            $this->title = get_string('pluginname', 'block_cesa_notes');
        }
    }

    /**
     * The content object.
     *
     * @return stdObject
     */
    public function get_content()
    {
        global $CFG, $PAGE;

        static $jscount = 0;
        if ($this->content !== null) {
            return $this->content;
        } else {
            $this->content = new \stdClass();
        }

        if (!isloggedin() or isguestuser()) {
            return '';      // Never useful unless you are logged in as real users
        }

        if (!in_array($PAGE->context->contextlevel, array(CONTEXT_COURSE, CONTEXT_SYSTEM, CONTEXT_MODULE, CONTEXT_USER))) {
            return '';
        }

        $this->content = new stdClass();

        if (!empty($this->config->title)) {
            $this->content->title =  format_text($this->config->title, FORMAT_HTML, array('filter' => true));
        } else {
            $this->content->title = get_string('cesa_notes', 'block_cesa_notes');
        }

        $this->content->text = '<div class="inline-cesa_notes-opener">' . get_string('showcesa_notes', 'block_cesa_notes') . '</div>';
        $this->content->footer = '';

        if (empty($this->instance)) {
            return $this->content;
        }

        if ($jscount == 0) {
            $this->block_cesa_notes_get_required_javascript();
            $jscount++;
        }

        return $this->content;
    }

    /*
     * load JS that requires into the page.
     */
    private function block_cesa_notes_get_required_javascript()
    {
        global $PAGE, $CFG;
        list($context, $course, $cm) = get_context_info_array($PAGE->context->id);
        $config = get_config('block_cesa_notes');

        $mm = new block_cesa_notes_manager();
        $currenttabindex = $mm->get_current_tab($context, $PAGE);
        $arguments = array(
            'arg' => array(
                'instanceid' => $this->instance->id,
                'editing' => ($PAGE->user_is_editing()),
                'editingicon_pos' => ($PAGE->user_is_editing()) ? 'cesa_notes-pos-inline' : $config->icondisplayposition,
                'maxallowedcharacters' => $config->characterlimit,
                'contextid' => $context->id,
                'maxallowedcharacters_warning' => get_string('notmorethan', 'block_cesa_notes', $config->characterlimit),
                'contextareas' => $mm->get_available_contextareas(),
                'currenttabindex' => ($currenttabindex == null ? 'site' : $currenttabindex),
                'perpage' => $config->cesa_notesperpage,
            ),
        );
        $PAGE->requires->string_for_js('charactersleft', 'block_cesa_notes');
        $PAGE->requires->string_for_js('notmorethan', 'block_cesa_notes');
        $PAGE->requires->string_for_js('cesa_notes', 'block_cesa_notes');
        $PAGE->requires->string_for_js('showcesa_notes', 'block_cesa_notes');
        $PAGE->requires->string_for_js('savedsuccess', 'block_cesa_notes');
        $PAGE->requires->string_for_js('save', 'block_cesa_notes');
        $PAGE->requires->string_for_js('placeholdercontent', 'block_cesa_notes');
        $PAGE->requires->string_for_js('deletecesa_notes', 'block_cesa_notes');
        $PAGE->requires->string_for_js('cesa_notescount', 'block_cesa_notes');
        $PAGE->requires->string_for_js('previouspage', 'block_cesa_notes');
        $PAGE->requires->string_for_js('nextpage', 'block_cesa_notes');
        $PAGE->requires->string_for_js('nothingtodisplay', 'block_cesa_notes');
        $PAGE->requires->string_for_js('cesa_notessavedundertab', 'block_cesa_notes');
        $PAGE->requires->string_for_js('cancel', 'moodle');
        $this->page->requires->js_call_amd('block_cesa_notes/cesa_notesblock', 'init', $arguments);
    }
}
