define([
  "jquery",
  "core/yui",
  "core/str"
], function ($, Y, str) {
  var CONFIG;
  var NODES = {
    DELETE_ICON: '<span class="delete">&#x274C;</span>',
  };
  var SELECTORS = {
    cesa_notes_ROOT: ".inline-cesa_notes-opener",
    cesa_notes_BASE: "#cesa_notes_base",
    cesa_notes_OPENER: ".cesa_notes-opener",
    cesa_notes_LISTS: ".cesa_notes_list",
  };
  var CSS = {
    cesa_notes_BASE: "cesa_notes_base",
    cesa_notes_OPENER: "cesa_notes-opener",
    cesa_notes_LISTS: "cesa_notes_list",
  };
  var panel = null;
  var initnotes = null;
  var strdeletenote = M.util.get_string("deletecesa_notes", "block_cesa_notes");

  var cesa_notes = {
    /** @alias module:blocks/cesa_notes */
    getcesa_notesValidatedUrl: function (baseurl) {
      var a = document.createElement("a");
      a.href = baseurl;
      return a.search.length > 0 ? baseurl : baseurl + "?";
    },
    /*
     * Validation for textarea input text
     */
    getWarnings: function (status) {
      if (status == false) {
        $("#addmynote-label-" + CONFIG.instanceid + "  span.warning").html(
          CONFIG.maxallowedcharacters_warning
        );
      } else {
        var ta = $("#id_mynotecontent-" + CONFIG.instanceid);
        if (ta.val() == "") {
          $("#addmynote-label-" + CONFIG.instanceid + "  span.warning").html(
            ""
          );
        } else {
          var cl = CONFIG.maxallowedcharacters - ta.val().length;
          $("#addmynote-label-" + CONFIG.instanceid + "  span.warning").html(
            M.util.get_string("charactersleft", "block_cesa_notes") + cl
          );
        }
      }
    },
    checkInputText: function () {
      var ta = $("#id_mynotecontent-" + CONFIG.instanceid);

      if (ta.val().length > CONFIG.maxallowedcharacters) {
        $("#addmynote_submit").attr("disabled", "true");
        return false;
      }

      $("#addmynote_submit").removeAttr("disabled");
      return true;
    },
    toggle_textarea: function (e) {
      var ta = $("#id_mynotecontent-" + CONFIG.instanceid);

      if (!ta) {
        return false;
      }
      var focus = e.type == "focusin";
      if (focus) {
        if (
          ta.val() ==
          M.util.get_string("placeholdercontent", "block_cesa_notes")
        ) {
          ta.val("");
          $(".textarea").css("border-color", "black");
        }
      } else {
        if (ta.val() == "") {
          ta.val(M.util.get_string("placeholdercontent", "block_cesa_notes"));
          $(".textarea").css("border-color", "gray");
          $("#addmynote-label-" + CONFIG.instanceid + "  span.warning").html(
            ""
          );
        }
      }
    },
    request: function (args) {
      var params = {};
      var scope = this;
      if (args["scope"]) {
        scope = args["scope"];
      }
      params["contextarea"] = scope.currenttab.replace(CONFIG.prefix, "");
      params["contextarea"] = params["contextarea"].replace("#", "");
      if (args.params) {
        for (i in args.params) {
          params[i] = args.params[i];
        }
      }
      params["sesskey"] = M.cfg.sesskey;

      var cfg = {
        method: "POST",
        on: {
          start: function () {
            //'<div class="mdl-align"><img src="'+M.util.image_url('i/loading', 'core')+'" /></div>';
          },
          complete: function (id, o, p) {
            if (!o) {
              alert("IO FATAL");
              return false;
            }
            var data = Y.JSON.parse(o.responseText);
            if (data.error) {
              if (data.error == "require_login") {
                args.callback(id, data, p);
                return true;
              }
              alert(data.error);
              return false;
            } else {
              args.callback(id, data, p);
              return true;
            }
          },
        },
        arguments: {
          scope: scope,
        },
        headers: {
          "Content-Type": "application/x-www-form-urlencoded; charset=UTF-8",
        },
        data: build_querystring(params),
      };
      if (args.form) {
        cfg.form = args.form;
      }
      Y.io(this.api, cfg);
    },
    printcesa_notes: function (e) {
      e.preventDefault();
      let note_content_input = $("#id_mynotecontent-" + CONFIG.instanceid);
      let arg = {
        action: "print",
      };

      note_content_input.attr("disabled", true);
      note_content_input.css({
        backgroundImage:
          "url(" + M.util.image_url("i/loading_small", "core") + ")",
        backgroundRepeat: "no-repeat",
        backgroundPosition: "center center",
      });

      this.request({
        params: arg,
        callback: function (id, ret, args) {
          $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr("disabled");
          $("#id_mynotecontent-" + CONFIG.instanceid).css({
            backgroundImage: "",
          });
        },
      });
    },
    savecesa_notes: function (e) {
      e.preventDefault();
      var scope = this;

      if (scope.checkInputText() == false) {
        return false;
      }
      var ta = $("#id_mynotecontent-" + CONFIG.instanceid);
      if (
        ta.val() == "" ||
        ta.val() == M.util.get_string("placeholdercontent", "block_cesa_notes")
      ) {
        return false;
      }
      let editingNoteId = ta.attr("data-editnoteid")
        ? ta
          .attr("data-editnoteid")
          .replace("mynote-" + CONFIG.instanceid + "-", "")
        : false;

      var arg = {
        contextid: CONFIG.contextid,
        content: ta.val(),
        action: editingNoteId ? "edit" : "add",
        contextarea: scope.currenttabindex,
        noteurl: window.location.href,
        noteToEditIt: editingNoteId,
      };

      ta.attr("disabled", true);
      ta.css({
        backgroundImage:
          "url(" + M.util.image_url("i/loading_small", "core") + ")",
        backgroundRepeat: "no-repeat",
        backgroundPosition: "center center",
      });
      this.request({
        params: arg,
        callback: function (id, ret, args) {
          if (!ret.notes) {
            return false;
          }

          $("#addmynote-label-" + CONFIG.instanceid + "  span.warning").html(
            ""
          );
          $("#id_mynotecontent-" + CONFIG.instanceid).val(
            M.util.get_string("placeholdercontent", "block_cesa_notes")
          );
          $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr("disabled");
          $("#id_mynotecontent-" + CONFIG.instanceid).css({
            backgroundImage: "",
          });
          if (scope.currenttab != scope.defaulttab) {
            scope.currenttab = scope.defaulttab;
            var tab = scope.currenttab.replace("#", "#tab-");
            $(SELECTORS.cesa_notes_BASE + " ul.tabs-menu li").removeClass(
              "current"
            );
            $(SELECTORS.cesa_notes_BASE + " " + tab).addClass("current");
            $(SELECTORS.cesa_notes_BASE + " .tab-content")
              .has(scope.currenttab)
              .addClass("current");
            $(SELECTORS.cesa_notes_BASE + " .tab-content")
              .not(scope.currenttab)
              .css("display", "none");
            $(
              SELECTORS.cesa_notes_BASE +
              " " +
              scope.currenttab +
              ".tab-content"
            ).css("display", "block");
          }
          scope.addToList(ret, "add");
          scope.displaycesa_notes();
          $(SELECTORS.cesa_notes_BASE)
            .find(".responsetext")
            .html(M.util.get_string("savedsuccess", "block_cesa_notes"));
          $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr(
            "data-editnoteid"
          );

          $(".j-delete-cesa-note").removeClass("show_delete_note_btn");
        },
      });
    },
    addToList: function (notesobj, action = "") {
      var scope = this;
      var el = $(SELECTORS.cesa_notes_BASE).find(scope.currenttab + "-list");
      console.log(el);
      if (action == "add") {
        console.log(notesobj.notes);
        el.prepend(scope.rendercesa_notes(notesobj.notes));
      } else {
        el.append(scope.rendercesa_notes(notesobj.notes));
        $(el)
          .find("li")
          .sort(sort_li) // sort elements
          .appendTo(el); // append again to the list
        // sort function callback
        function sort_li(a, b) {
          return $(b).data("itemid") > $(a).data("itemid") ? 1 : -1;
        }
      }
      $(SELECTORS.cesa_notes_BASE)
        .find(scope.currenttab)
        .attr("notes-count", notesobj.count);
    },
    getcesa_notes: function (page = 0) {
      var scope = this;
      page = parseInt(page);
      var el = $(SELECTORS.cesa_notes_BASE).find(scope.currenttab + "-list");
      var notescount = el.find("li").length;
      var lastpage = Math.ceil(notescount / CONFIG.perpage);
      if (notescount > 0 && lastpage > page) {
        scope.displaycesa_notes();
        return false;
      }
      var arg = {
        contextid: CONFIG.contextid,
        action: "get",
        page: page,
      };
      this.request({
        params: arg,
        callback: function (id, ret, args) {
          scope.addToList(ret);
          scope.displaycesa_notes();
        },
      });
    },
    updatecesa_notesInfo: function (cesa_notescount, page) {
      page = parseInt(page);
      cesa_notescount = parseInt(cesa_notescount);
      var scope = this;
      var paging = "";
      if (cesa_notescount > CONFIG.perpage) {
        var pagenum = page - 1;
        var prevlink = "";
        var nextlink = "";

        if (page > 0) {
          prevlink = scope.createLink(
            pagenum,
            M.util.get_string("previouspage", "block_cesa_notes"),
            "previous"
          );
        }
        if (CONFIG.perpage > 0) {
          var lastpage = Math.ceil(cesa_notescount / CONFIG.perpage);
        } else {
          var lastpage = 1;
        }
        // Uncomment this line if you want to display page number
        //paging += '<span class="current-page">' + (page + 1) + '</span>';
        pagenum = page + 1;
        if (pagenum != lastpage) {
          nextlink = scope.createLink(
            pagenum,
            M.util.get_string("nextpage", "block_cesa_notes"),
            "next"
          );
        }
        paging = prevlink;
        if (prevlink != "" && nextlink != "") {
          paging += '<span class="separator"></span>';
        }
        paging += nextlink;

        paging = '<span class="paging">' + paging + "</span>";
      }
      var noteinfo = $(SELECTORS.cesa_notes_BASE).find(scope.currenttab);
      if (cesa_notescount > 0) {
        noteinfo
          .find(".count")
          .html(
            M.util.get_string("cesa_notescount", "block_cesa_notes") +
            "" +
            cesa_notescount
          );
      } else {
        noteinfo
          .find(".count")
          .html(M.util.get_string("nothingtodisplay", "block_cesa_notes"));
      }
      noteinfo.find(".cesa_notes-paging").html(paging);
    },
    /*
     * Render notes as html ul li element
     */
    rendercesa_notes: function (notes) {
      if (notes.length < 1) {
        return false;
      }
      var lists = "";
      var x = "";
      for (x in notes) {
        $("#mynote-" + CONFIG.instanceid + "-" + notes[x].id).remove();
        var deletelink =
          '<a href="#" id="mynote-delete-' +
          CONFIG.instanceid +
          "-" +
          notes[x].id +
          '" class="mynote-delete" title="' +
          strdeletenote +
          '">' +
          NODES.DELETE_ICON +
          "</a>";
        var notedetail = "";
        var userdate = '<span class="time">' + notes[x].timecreated + "</span>";
        if (notes[x].coursename != "") {
          notedetail =
            '<div class="note-detail">' +
            notes[x].coursename +
            " - " +
            userdate +
            "</div>";
        } else {
          notedetail = '<div class="note-detail">' + userdate + "</div>";
        }

        var note_html =
          '<div class="content" data-noteid="mynote-' +
          CONFIG.instanceid +
          "-" +
          notes[x].id +
          '">' +
          notes[x].content +
          "</div>";
        var note_edit_btn =
          '<button class="j-cesa-note-content-edit">Editar</button>';
        lists +=
          '<li id="mynote-' +
          CONFIG.instanceid +
          "-" +
          notes[x].id +
          '" data-itemid="' +
          notes[x].id +
          '">' +
          note_edit_btn +
          note_html +
          notedetail +
          "</li>";
      }
      return lists;
    },
    createLink: function (page, text, classname) {
      var classattribute =
        typeof classname != "undefined" ? ' class="' + classname + '"' : "";
      return (
        '<a href="' +
        this.api +
        "&page=" +
        page +
        '"' +
        classattribute +
        ">" +
        text +
        "</a>"
      );
    },
    displaycesa_notes: function () {
      var scope = this;
      var page = parseInt(
        $(SELECTORS.cesa_notes_BASE).find(scope.currenttab).attr("onpage")
      );
      var cesa_notescount = parseInt(
        $(SELECTORS.cesa_notes_BASE).find(scope.currenttab).attr("notes-count")
      );
      var el = $(SELECTORS.cesa_notes_BASE).find(
        " " + scope.currenttab + "-list"
      );
      var notescount = el.find("li").length;
      var lastpage = Math.ceil(notescount / CONFIG.perpage);

      if (notescount > 0 && lastpage <= page) {
        page = lastpage - 1;
      }
      var upperlimit = page * CONFIG.perpage + CONFIG.perpage;
      var lowerlimit = page * CONFIG.perpage;
      el.find("li").css("display", "none");
      el.find("li").each(function (i, el) {
        if (i >= lowerlimit && i < upperlimit) {
          $(el).css("display", "block");
        }
      });
      scope.updatecesa_notesInfo(cesa_notescount, page);
      //panel.centerDialogue();
    },
    registerActions: function () {
      var scope = this;

      $("body").delegate("#addmynote_cancel", "click", function () {
        panel.hide();
      });

      $("body").delegate(".j-cesa-note-content-edit", "click", function () {
        let noteText = $(this).parent().find(".text_to_html").text();
        let textArea = $(".cesa_notes_base .textarea textarea");
        let deleteButton = $(".j-delete-cesa-note");

        deleteButton.addClass("show_delete_note_btn");
        textArea.attr(
          "data-editnoteid",
          $(this).parent().find(".content").attr("data-noteid")
        );
        textArea.val(noteText);
      });
      $("body").delegate(
        ".modal_cesa_notes_root .modal-header button.close",
        "click",
        function (e) {
          $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr(
            "data-editnoteid"
          );
          $("#id_mynotecontent-" + CONFIG.instanceid).val("");
          $(".j-delete-cesa-note").removeClass("show_delete_note_btn");
          $("#cesa_notes_delete_modal").removeClass("show_delete_modal");
        }
      );
      $("body").delegate(
        "#cesa_notes_modal_cancel_delete",
        "click",
        function (e) {
          $("#cesa_notes_delete_modal").removeClass("show_delete_modal");
        }
      );
      $("body").delegate(
        "#cesa_notes_modal_accept_delete",
        "click",
        function (e) {
          var nid = $("#id_mynotecontent-" + CONFIG.instanceid).attr(
            "data-editnoteid"
          );
          if (nid != "" || nid != "undefined") {
            var notescount = $(SELECTORS.cesa_notes_BASE).find(
              SELECTORS.cesa_notes_LISTS + "-" + scope.currenttab + " > li"
            ).length;
            var id = nid.replace("mynote-" + CONFIG.instanceid + "-", "");
            var arg = {
              contextid: CONFIG.contextid,
              action: "delete",
              noteid: id,
              lastnotecounts: notescount,
            };
            scope.request({
              params: arg,
              callback: function (id, ret, args) {
                args.scope.addToList(ret);
                $("#mynote-" + CONFIG.instanceid + "-" + ret.noteid).remove();
                $(".j-delete-cesa-note").removeClass("show_delete_note_btn");
                $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr(
                  "data-editnoteid"
                );
                $("#id_mynotecontent-" + CONFIG.instanceid).val("");
                $("#cesa_notes_delete_modal").removeClass("show_delete_modal");
                args.scope.displaycesa_notes();
              },
            });
          }
        }
      );
      $("body").delegate("#addmynote_submit", "click", function (e) {
        scope.savecesa_notes(e);
      });
      //$('body').delegate('#cesa_notes_print', 'click', function(e) {scope.printcesa_notes(e)});
      $("body").delegate(
        SELECTORS.cesa_notes_BASE + " ul.tabs-menu li",
        "click",
        function (e) {
          $(this).addClass("current");
          $(this).siblings().removeClass("current");
          var tab = $(this).attr("id").replace("tab-", "");
          $(SELECTORS.cesa_notes_BASE + " .tab-content")
            .not("#" + tab)
            .css("display", "none");
          $(SELECTORS.cesa_notes_BASE + " #" + tab + ".tab-content").css(
            "display",
            "block"
          );
          scope.currenttab = "#" + tab;

          var isloaded = $(scope.currenttab).attr("data-loaded");
          if (typeof isloaded == "undefined" || isloaded == false) {
            $(SELECTORS.cesa_notes_BASE)
              .find(scope.currenttab)
              .attr("data-loaded", "true");
            scope.getcesa_notes(0);
          }
        }
      );

      $("body").delegate(
        "#id_mynotecontent-" + CONFIG.instanceid,
        "focus blur",
        function (e) {
          scope.toggle_textarea(e);
        }
      );
      $("body").delegate(
        "#id_mynotecontent-" + CONFIG.instanceid,
        "change",
        function (e) {
          scope.getWarnings(scope.checkInputText());
        }
      );

      $("body").delegate(
        SELECTORS.cesa_notes_BASE + " .cesa_notes-paging .paging a",
        "click",
        function (e) {
          e.preventDefault();
          var regex = new RegExp(/[\?&]page=(\d+)/);
          var results = regex.exec($(this).attr("href"));
          var page = 0;
          if (results[1]) {
            page = results[1];
          }
          $(SELECTORS.cesa_notes_BASE)
            .find(scope.currenttab)
            .attr("onpage", parseInt(page));
          scope.getcesa_notes(page);
        }
      );

      $("body").delegate(
        SELECTORS.cesa_notes_BASE + " .j-delete-cesa-note",
        "click",
        function (e) {
          e.preventDefault();
          var nid = $("#id_mynotecontent-" + CONFIG.instanceid).attr(
            "data-editnoteid"
          );
          if (nid != "" || nid != "undefined") {
            let deleteModal = $("#cesa_notes_delete_modal");
            deleteModal.addClass("show_delete_modal");
          }
        }
      );
      $("body").delegate(
        SELECTORS.cesa_notes_BASE + " a.mynote-delete",
        "click",
        function (e) {
          e.preventDefault();
          $("#id_mynotecontent-" + CONFIG.instanceid).removeAttr(
            "data-editnoteid"
          );
          var nid = $(this).attr("id");
          if (nid != "" || nid != "undefined") {
            var notescount = $(SELECTORS.cesa_notes_BASE).find(
              SELECTORS.cesa_notes_LISTS + "-" + scope.currenttab + " > li"
            ).length;
            var id = nid.replace(
              "mynote-delete-" + CONFIG.instanceid + "-",
              ""
            );
            var arg = {
              contextid: CONFIG.contextid,
              action: "delete",
              noteid: id,
              lastnotecounts: notescount,
            };
            scope.request({
              params: arg,
              callback: function (id, ret, args) {
                args.scope.addToList(ret);
                $("#mynote-" + CONFIG.instanceid + "-" + ret.noteid).remove();
                args.scope.displaycesa_notes();
              },
            });
          }
        }
      );
    },
    /**
     * Initialize cesa_notes
     * @access public
     * @param {int} instanceid
     * @param {int} contextid
     * @param {int} maxallowedcharacters
     * @param {int} perpage
     * @param {string} editingicon_pos
     * @param {bool} editing
     * @param {string} adminurl
     * @param {array} contextareas
     * @param {string} currenttabindex
     */
    init: function (args) {
      CONFIG = args;
      CONFIG.prefix = "cesa_notes_";
      CONFIG.printapi = this.getcesa_notesValidatedUrl(
        M.cfg.wwwroot + "/blocks/cesa_notes/cesa_notes_print.php"
      );
      this.perpage = parseInt(CONFIG.perpage);
      this.currenttab = "#cesa_notes_" + args.currenttabindex;
      this.defaulttab = "#cesa_notes_" + args.currenttabindex;
      this.currenttabindex = args.currenttabindex;
      this.api = this.getcesa_notesValidatedUrl(
        M.cfg.wwwroot + "/blocks/cesa_notes/cesa_notes_ajax.php"
      );
      var strtitle = M.util.get_string("showcesa_notes", "block_cesa_notes");

      var scope = cesa_notes;

      str
        .get_strings([
          { key: "cesa_notes", component: "block_cesa_notes" },
          { key: "characterlimit", component: "block_cesa_notes" },
          { key: "save", component: "block_cesa_notes" },
          { key: "cancel" },
          {
            key: "cesa_notessavedundertab",
            component: "block_cesa_notes",
            param: CONFIG.contextareas[scope.currenttabindex],
          },
          { key: "placeholdercontent", component: "block_cesa_notes" },
        ])
        .done(function (s) {
          // Create basic tab structure

          let deleteModal = `<div id="cesa_notes_delete_modal">
                                    <div class="cesa_notes_delete_modal_content">
                                        <p>¿Estás seguro de que quieres eliminar este apunte?</p>
                                        <button id="cesa_notes_modal_cancel_delete">Cancelar</button>
                                        <button id="cesa_notes_modal_accept_delete">Eliminar</button>
                                    </div>
                                    </div>`;

          var el = $("<div></div>").append(
            $(
              '<div id="' +
              CSS.cesa_notes_BASE +
              '" class="' +
              CSS.cesa_notes_BASE +
              '">' +
              deleteModal +
              "</div>"
            )
              .append(
                '<div class="inputarea"><div class="responsetext"></div><div class="cesa-notes-limit" id="addmynote-label-' +
                CONFIG.instanceid +
                '">' +
                s[1] +
                " " +
                CONFIG.maxallowedcharacters +
                '<span class="warning"></span></div>' +
                '<div class="textarea">' +
                '<textarea id="id_mynotecontent-' + CONFIG.instanceid +
                '" name="mynotecontent" rows="2">' +
                s[5] +
                "</textarea></div>" +
                '<p class="notesavedhint">' +
                s[4] +
                "</p>" +
                '<div class="cesa_notes_buttons_container">' +
                '<button class="j-delete-cesa-note">Eliminar</button>' +
                '<button type="submit" id="addmynote_submit"></button>' +
                '</div>' +
                '<p class="cesa_note_bottom_container"><a class="cesa_notes_print" target="_blank" href="' +
                CONFIG.printapi +
                '">Imprimir notas</a> </p>' +
                "</div>"
              )
              .append($('<ul class="tabs-menu"></ul>'))
              .append($('<div class="tab"></div>'))
          );
          el.find("#addmynote_submit").append(s[2]);
          el.find("#addmynote_cancel").attr("value", s[3]);

          var tabsmenu = "";
          var tabcontents = "";
          var i = "";
          for (i in CONFIG.contextareas) {
            if (scope.currenttabindex == i) {
              tabsmenu +=
                '<li class="current" id="tab-' +
                CONFIG.prefix +
                i +
                '"><div class="menu-item">' +
                CONFIG.contextareas[i] +
                "</div></li>";
            } else {
              tabsmenu +=
                '<li class="" id="tab-' +
                CONFIG.prefix +
                i +
                '"><div class="menu-item">' +
                CONFIG.contextareas[i] +
                "</div></li>";
            }
            tabcontents +=
              '<div class="tab-content" id="' +
              CONFIG.prefix +
              i +
              '" onpage="0" notes-count="0">' +
              '<div class="notes-info"><div class="cesa_notes-paging"></div><div class="count"></div></div>' +
              '<ul id="' +
              CONFIG.prefix +
              i +
              '-list" class="cesa_notes_lists"></ul>' +
              "</div>";
          }
          el.find(".tabs-menu").append(tabsmenu);
          el.find(".tab").append($(tabcontents));

          $(SELECTORS.cesa_notes_ROOT).html(el.html());

          if (initnotes === null) {
            initnotes = true;
            // Get initial notes
            scope.getcesa_notes(0);
            $(SELECTORS.cesa_notes_BASE)
              .find(scope.currenttab)
              .attr("data-loaded", "true");
            $(SELECTORS.cesa_notes_BASE)
              .find(scope.currenttab)
              .css("display", "block");
          }

          scope.registerActions();
        });


    },
  };

  return cesa_notes;
});
