<?php

require_once('../../config.php');

defined('MOODLE_INTERNAL') || die();

global $CFG, $DB, $COURSE;

$id = required_param('id', PARAM_INT);    // Course Module ID.
$rating = required_param('rating', PARAM_INT);  // User selection.

if (! $course = $DB->get_record('course', array('id' => $id))) {
    print_error('Course ID not found');
}

require_login($course, false);
if (!$context = get_context_instance(CONTEXT_COURSE, $course->id)) {
    print_error('nocontext');
}

require_capability('block/cesa_course_rating:rate', $context);
global $USER;

// Validación: Verificar si el usuario ya ha calificado este curso
if ($DB->record_exists('block_cesa_course_rating', array('course' => $COURSE->id, 'user' => $USER->id))) {
    redirect($CFG->wwwroot . '/course/view.php?id=' . $COURSE->id, get_string('already_rated', 'block_cesa_course_rating'), null, \core\output\notification::NOTIFY_WARNING);
}

if ($form = data_submitted()) {
    // Si el usuario no ha calificado, se inserta el registro
    $DB->insert_record('block_cesa_course_rating', array('course' => $COURSE->id, 'user' => $USER->id, 'rating' => $rating));
    redirect($CFG->wwwroot . '/course/view.php?id=' . $COURSE->id, get_string('rating_success', 'block_cesa_course_rating'), null, \core\output\notification::NOTIFY_SUCCESS);
}
