<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (#)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block6', get_string('settingsblock6', 'theme_universechild'));

$name = 'theme_universechild/displayblock6';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock6_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #6</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock6';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<div class="row row-cols-1 row-cols-md-2 row-cols-lg-3">

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M12 11.5v5M12 7.51l.01-.011M12 22c5.523 0 10-4.477 10-10S17.523
2 12 2 2 6.477 2 12s4.477 10 10 10z" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">Moodle 4.x</h3>
<p class="rui-card-text--md">universechild theme works with Moodle 4.1, 4.0.</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">Check All Moodle Themes</a>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="1.5"></circle>
<path d="M16.583 9.667C15.81 8.097 14.043 7 11.988 7 9.388 7 7.25 8.754 7 11"
stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M14.494 9.722H16.4a.6.6 0 00.6-.6V7.5M7.417 13.667C8.191 15.629 9.957 17
12.012 17c2.6 0 4.736-2.193 4.988-5" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M9.506 13.622H7.6a.6.6 0 00-.6.6V16.4" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">Updates</h3>
<p class="rui-card-text--md">Get new features, improvements, and bug fixes in each future update.;</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">Get this theme</a>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M20 11a8 8 0 10-16 0" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M2 15.438v-1.876a2 2 0 011.515-1.94l1.74-.436a.6.6 0
01.745.582v5.463a.6.6 0 01-.746.583l-1.74-.435A2 2 0 012 15.439zM22
15.438v-1.876a2 2 0 00-1.515-1.94l-1.74-.436a.6.6 0 00-.745.582v5.463a.6.6
0 00.745.583l1.74-.435A2 2 0 0022 15.439zM20 18v.5a2 2 0 01-2 2h-3.5"
stroke="currentColor" stroke-width="1.5"></path>
<path d="M13.5 22h-3a1.5 1.5 0 010-3h3a1.5 1.5 0 010 3z"
stroke="currentColor" stroke-width="1.5"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">Support</h3>
<p class="rui-card-text--md">I also provide free customer support even when...</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">Support page</a>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M14.272 10.445L18 2m-8.684 8.632L5 2m7.761 8.048L8.835 2m5.525
0l-1.04 2.5M6 16a6 6 0 1012 0 6 6 0 00-12 0z" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M10.5 15l2-1.5v5" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">Top-notch quality</h3>
<p class="rui-card-text--md">With supporting text below as a natural....</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">New features list</a>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M11 13.6V21H3.6a.6.6 0 01-.6-.6V13h7.4a.6.6 0 01.6.6zM11 21h3M3
13v-3M6 3H3.6a.6.6 0 00-.6.6V6M14 3h-4M21 10v4M18 3h2.4a.6.6 0 01.6.6V6M18
21h2.4a.6.6 0 00.6-.6V18M11 10h3v3" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">Built from scratch</h3>
<p class="rui-card-text--md">It is not the Boost-based theme...</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">Learn more</a>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--smpl">
<div class="rui-card-body">

<!-- icon -->
<div class="rui-rounded-icon rui-rounded-icon--gray mb-3">
<svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M3 11.507a9.493 9.493 0 0018 4.219c-8.507 0-12.726-4.22-12.726-12.726A9.494
9.494 0 003 11.507z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->

<h3 class="rui-card-title">In-build Dark Mode</h3>
<p class="rui-card-text--md">Optional in-build dark mode theme. Decide which one you prefer more.</p>
<a href="#" target="_blank" class="rui-card-btn-link underline--anim">Documentation</a>
</div>
</div>
</div>
<!-- End item -->

</div>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block6customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
